unit fROR_OtherRegistries;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   March 27, 2013
*       Site:           Hines OIFO
*       Developers:     Ed Micyus
*       Description:    Data entry window used to replace TMS advanced column
*                       grid for visually impaired users.
*
*       Notes:
*
================================================================================
}
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFormOtherRegistries = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    cmbMode0: TComboBox;
    lblMode0: TLabel;
    lblRegistry0: TLabel;
    edtRegistry0: TEdit;
    stxtInstruct: TStaticText;
    procedure FormShow(Sender: TObject);
    procedure cmbModeChange(Sender: TObject);
  private
    { Private declarations }
    fListData: TStringList;
    fModes: TStringList;
    fRegs: TStringList;
    fIENs:  TStringList;
  public
    { Public declarations }
    constructor Create(aList: TStringList; aOwner: TComponent = nil); reintroduce;
    destructor  Destroy; override;

    property ListData: TStringList          read fListData;

    function Edit: integer;
  end;

var
  FormOtherRegistries: TFormOtherRegistries;

implementation

uses uROR_Common, uROR_Utilities;

{$R *.dfm}

function getItemIndex(const aMode: String): integer;
begin
  Result := 1;
  if aMode = 'Include' then
    Result := 0
  else if aMode = 'Exclude' then
    Result := 2;
end;

constructor TFormOtherRegistries.Create(aList: TStringList; aOwner: TComponent);
var i: integer;
  lbl1, lbl2: TLabel;
  edt1: TEdit;
  cmb1: TComboBox;
begin
  if Assigned(aOwner) then
    inherited Create(aOwner)
  else
    inherited Create(Application);

  fListData := aList;
  fModes := TStringList.Create;
  fRegs  := TStringList.Create;
  fIENs  := TStringList.Create;
  for i := 0 to fListData.Count - 1 do
  begin
    fModes.Add(Piece(fListData[i], U, 1));
    fRegs.Add(Piece(fListData[i], U, 2));
    fIENs.Add(Piece(fListData[i], U, 3));
  end;

  //Load values for first registry
  edtRegistry0.Text := fRegs[0];
  cmbMode0.ItemIndex := getItemIndex(fModes[0]);

  //Create controls for the remainder of the registries
  for i := 1 to fListData.Count - 1 do
  begin
    lbl1 := TLabel.Create(self);
    lbl1.Name    := Format('lblRegistry%d', [i]);
    lbl1.Caption := lblRegistry0.Caption;
    lbl1.Left    := lblRegistry0.Left;
    lbl1.Top     := lblRegistry0.Top + (i * 25);
    lbl1.Parent  := self;

    edt1 := TEdit.Create(self);
    edt1.Name       := Format('edtRegistry%d', [i]);
    edt1.Color      := edtRegistry0.Color;
    edt1.Tag        := i;
    edt1.Text       := fRegs[i];
    edt1.Left       := edtRegistry0.Left;
    edt1.Top        := edtRegistry0.Top + (i * 25);
    edt1.Width      := edtRegistry0.Width;
    edt1.ReadOnly   := true;
    edt1.Parent     := self;

    lbl2         := TLabel.Create(self);
    lbl2.Name    := Format('lblMode%d', [i]);
    lbl2.Caption := 'Mode';
    lbl2.Left    := lblMode0.Left;
    lbl2.Top     := lblMode0.Top + (i * 25);
    lbl2.Parent  := self;

    cmb1         := TComboBox.Create(self);
    cmb1.Name    := Format('cmbMode%d', [i]);
    cmb1.Tag     := i;
    cmb1.Parent  := self;
    cmb1.Left    := cmbMode0.Left;
    cmb1.Top     := cmbMode0.Top + (i * 25);
    cmb1.Width   := cmbMode0.Width;
    cmb1.Items.Add('Include');
    cmb1.Items.Add('Ignore');
    cmb1.Items.Add('Exclude');
    cmb1.ItemIndex := getItemIndex(fModes[i]);
    cmb1.SelLength := 0;
    cmb1.OnChange := cmbModeChange;

    self.Height := self.Height + 25;
  end;
end;

destructor TFormOtherRegistries.Destroy;
begin
  fListData := nil;
  inherited;
end;

procedure TFormOtherRegistries.FormShow(Sender: TObject);
begin
  stxtInstruct.SetFocus;
end;

function TFormOtherRegistries.Edit: Integer;
begin
  Result := ShowModal;
end;

procedure TFormOtherRegistries.cmbModeChange(Sender: TObject);
var iTag: integer;
begin
  iTag := (Sender as TComboBox).Tag;
  ListData[iTag] := (Sender as TComboBox).Items[(Sender as TComboBox).ItemIndex]
    + U + piece(ListData[iTag], U, 2, 4);
end;

end.
